<?php

namespace App\Http\Controllers;

use App\Models\Sucursal as ModelsSucursal;
use Illuminate\Http\Request;

use App\Models\Ubicacion;

class SucursalController extends Controller
{
    public function index()
    {
        $sucursales = Ubicacion::all();
        return view('sucursal.index', compact('sucursales'));
    }

    public function create()
    {
        return view('sucursal.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nombre' => [
                'required',
                'string',
                'max:255',
                'regex:/^[a-zA-Z0-9\s]+$/'
            ],
            'ubicacion' => [
                'required',
                'string',
                'max:255',
                'regex:/^[a-zA-Z0-9\s#\.]+$/'
            ],
            'telefono' => [
                'required',
                'digits:8',
            ],
        ], [
            'nombre.required' => 'El nombre es obligatorio.',
            'nombre.regex' => 'El nombre solo puede contener letras, números y espacios.',
            'nombre.max' => 'El nombre no puede superar los 255 caracteres.',
            'ubicacion.required' => 'La dirección es obligatoria.',
            'ubicacion.regex' => 'La dirección solo puede contener letras, números, espacios, "#" y puntos.',
            'ubicacion.max' => 'La dirección no puede superar los 255 caracteres.',
            'telefono.required' => 'El teléfono es obligatorio.',
            'telefono.digits' => 'El teléfono debe tener exactamente 8 dígitos.',
        ]);
    
        Ubicacion::create($request->all());
    
        return redirect()->route('sucursal.index')
            ->with('success', 'Sucursal creada exitosamente.');
    }


    public function edit(Ubicacion $sucursal)
    {
        return view('sucursal.edit', compact('sucursal'));
    }
    

   
public function update(Request $request, Ubicacion $sucursal)
{
    $request->validate([
        'nombre' => [
            'required',
            'string',
            'max:255',
            'regex:/^[a-zA-Z0-9\s]+$/'
        ],
        'ubicacion' => [
            'required',
            'string',
            'max:255',
            'regex:/^[a-zA-Z0-9\s#\.]+$/'
        ],
        'telefono' => [
            'required',
            'digits:8',
        ],
    ], [
        'nombre.required' => 'El nombre es obligatorio.',
        'nombre.regex' => 'El nombre solo puede contener letras, números y espacios.',
        'nombre.max' => 'El nombre no puede superar los 255 caracteres.',
        'ubicacion.required' => 'La dirección es obligatoria.',
        'ubicacion.regex' => 'La dirección solo puede contener letras, números, espacios, "#" y puntos.',
        'ubicacion.max' => 'La dirección no puede superar los 255 caracteres.',
        'telefono.required' => 'El teléfono es obligatorio.',
        'telefono.digits' => 'El teléfono debe tener exactamente 8 dígitos.',
    ]);

    $sucursal->update($request->all());

    return redirect()->route('sucursal.index')
        ->with('success', 'Sucursal actualizada exitosamente.');
}

    public function destroy(Ubicacion $sucursal)
    {
        $sucursal->delete();

        return redirect()->route('sucursal.index')
            ->with('success', 'Sucursal eliminada exitosamente.');
    }
}
