<?php

namespace App\Imports;

use App\Models\Producto;
use App\Models\Ubicacion;
use Illuminate\Support\Collection;
use PhpOffice\PhpSpreadsheet\Reader\IReadFilter;

class ImportProductos implements IReadFilter
{
    public function readCell(string $columnAddress, int $row, string $worksheetName = ''): bool
    {
        return true; // Leer todas las celdas
    }

    public function collection(Collection $rows)
    {
        foreach ($rows as $row) {
            // Validar y asignar valores predeterminados
            $nombre = $row[0] ?? 'Sin nombre';
            $codigo1 = $row[1] ?? null;
            $codigo2 = $row[2] ?? null;
            $descripcion = $row[3] ?? 'Sin descripción';

            $precios = [
                'precio_unidad_facturado' => $row[4] ?? 0,
                'precio_docena_facturado' => $row[5] ?? 0,
                'precio_paquete_facturado' => $row[6] ?? 0,
                'precio_paquete_normal' => $row[7] ?? 0,
                'precio_docena_normal' => $row[8] ?? 0,
                'precio_docena_caja' => $row[9] ?? 0,
            ];

            $descuento = $row[10] ?? 0;
            $incremento = $row[11] ?? 0;

            // Validar que no haya incremento y descuento simultáneamente
            if ($incremento > 0 && $descuento > 0) {
                continue;
            }

            $marca = $row[12] ?? 'Sin marca';
            $foto = $row[13] ?? null;
            $piezasPorPaquete = $row[14] ?? 1;
            $piezasPorCaja = $row[15] ?? 1;
            $ubicacionNombre = $row[16] ?? 'Ubicación Desconocida';
            $cantidad = $row[17] ?? 0;
            $posicion = $row[18] ?? 'Sin posición';
            $docena = isset($row[19]) && strtolower($row[19]) === 'si' ? true : false; // Nuevo campo `docena`

            // Obtener o crear la ubicación
            $ubicacion = Ubicacion::firstOrCreate(['nombre' => $ubicacionNombre]);

            // Aplicar incremento o descuento a los precios
            foreach ($precios as $key => &$value) {
                if ($incremento > 0) {
                    $value += ($value * $incremento / 100);
                } elseif ($descuento > 0) {
                    $value -= ($value * $descuento / 100);
                }
            }

            // Crear el producto
            Producto::create([
                'nombre' => $nombre,
                'codigo1' => $codigo1,
                'codigo2' => $codigo2,
                'descripcion' => $descripcion,
                'marca' => $marca,
                'foto' => $foto,
                'cantidad' => $cantidad,
                'piezas_por_paquete' => $piezasPorPaquete,
                'piezas_por_caja' => $piezasPorCaja,
                'ubicacion_id' => $ubicacion->id,
                'estado' => 'activo',
                'descuento' => $descuento,
                'incremento' => $incremento,
                'posicion' => $posicion,
                'docena' => $docena, // Nuevo campo `docena`
            ] + $precios);
        }
    }
}
