<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DetallePreventa extends Model
{
    use HasFactory;

    protected $fillable = [
        'preventa_id',
        'producto_id',
        'cantidad',
        'precio',
        'precio_total',
    ];

    public function preventa()
    {
        return $this->belongsTo(Preventa::class);
    }

    public function producto()
    {
        return $this->belongsTo(Producto::class);
    }
}
