<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Producto extends Model
{
    use HasFactory;

    protected $fillable = [
        'nombre',
        'codigo1',
        'codigo2',
        'descripcion',
        'precio_unidad_facturado',
        'precio_docena_facturado',
        'precio_paquete_facturado',
        'precio_paquete_normal',
        'precio_docena_normal',
        'precio_docena_caja',
        'piezas_por_paquete',
        'piezas_por_caja',
        'ubicacion_deposito',
        'descuento',
        'incremento',
        'marca',
        'foto',
        'cantidad',
        'ubicacion_id',
        'estado',
        'posicion', 
        'docena',
    ];
    
    public function productosVendidos()
    {
        return $this->hasMany(ProductosVendido::class, 'producto_id');
    }
    
    /**
     * Relación con la tabla de ubicaciones.
     */
    public function ubicacion()
    {
        return $this->belongsTo(Ubicacion::class);
    }

    /**
     * Filtrar productos por ubicación.
     */
    public function getProductosByUbicacion($ubicacionId)
    {
        try {
            $productos = self::where('ubicacion_id', $ubicacionId)->get([
                'id',
                'nombre',
                'cantidad',
                'precio_unidad_facturado',
                'precio_docena_facturado',
                'precio_paquete_facturado',
                'precio_paquete_normal',
                'precio_docena_normal',
                'precio_docena_caja'
            ]);

            if ($productos->isEmpty()) {
                return response()->json(['message' => 'No se encontraron productos para esta sucursal.'], 404);
            }

            return response()->json($productos, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Error en el servidor: ' . $e->getMessage()], 500);
        }
    }

    /**
     * Aplicar descuento a todos los precios.
     *
     * @return void
     */
    public function aplicarDescuento()
    {
        if ($this->descuento > 0) {
            $factorDescuento = 1 - ($this->descuento / 100);
            $this->precio_unidad_facturado *= $factorDescuento;
            $this->precio_docena_facturado *= $factorDescuento;
            $this->precio_paquete_facturado *= $factorDescuento;
            $this->precio_paquete_normal *= $factorDescuento;
            $this->precio_docena_normal *= $factorDescuento;
            $this->precio_docena_caja *= $factorDescuento;
            $this->save();
        }
    }
}
