<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductoVendido extends Model
{
    use HasFactory;

    protected $table = 'productos_vendidos';

    protected $fillable = [
        'venta_id',
        'producto_id',
        'ubicacion_id', // Ubicación del producto vendido
        'cantidad',
        'cantidad_total',
        'tipo_medida',
        'precio',
        'precio_total',
        'tipo_precio',
    ];

    public function venta()
    {
        return $this->belongsTo(Venta::class);
    }

    public function producto()
    {
        return $this->belongsTo(Producto::class);
    }

    public function ubicacion()
    {
        return $this->belongsTo(Ubicacion::class);
    }
}
