<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductosTable extends Migration
{
    public function up()
    {
        Schema::create('productos', function (Blueprint $table) {
            $table->id();
            $table->string('nombre');
            $table->string('codigo1')->nullable();
            $table->string('codigo2')->nullable();
            $table->string('descripcion')->nullable();
            
            // Nuevos precios según requisitos
            $table->decimal('precio_unidad_facturado', 10, 2)->nullable(); // PUF
            $table->decimal('precio_docena_facturado', 10, 2)->nullable(); // PDF
            $table->decimal('precio_paquete_facturado', 10, 2)->nullable(); // PPF
            $table->decimal('precio_paquete_normal', 10, 2)->nullable(); // PPN
            $table->decimal('precio_docena_normal', 10, 2)->nullable(); // PDN
            $table->decimal('precio_docena_caja', 10, 2)->nullable(); // PDC
            
            // Características adicionales del producto
            $table->integer('piezas_por_paquete')->nullable(); // pcs/p
            $table->integer('piezas_por_caja')->nullable(); // pcs/ctn
            $table->string('ubicacion_deposito')->nullable(); // Ubicación dentro del depósito
            
            // Foto y descuento
            $table->string('foto')->nullable();
    
            $table->decimal('descuento', 5, 2)->default(0)->nullable(); // Campo de descuento en porcentaje
            $table->decimal('incremento', 5, 2)->default(0)->nullable(); 
            // Campos existentes
            $table->string('marca')->nullable();
            $table->integer('cantidad')->nullable();
            $table->enum('estado', ['activo', 'inactivo'])->default('activo');
            $table->boolean('docena')->default(false); // Si o no para venta en docena
            // Relación con ubicaciones
            $table->unsignedBigInteger('ubicacion_id');
            $table->foreign('ubicacion_id')->references('id')->on('ubicaciones')->onDelete('cascade');
            $table->string('posicion')->nullable();
            
            // Timestamps
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('productos');
    }
}
