<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTraspasoConfigTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('traspaso_config', function (Blueprint $table) {
            $table->id();
            $table->integer('cantidad_maxima')->default(10)->nullable();
            $table->string('nombre_sistema')->nullable();
            $table->string('logo_path')->nullable();
            $table->decimal('tipo_cambio', 8, 2)->default(1.00);
            $table->timestamps();
        });
    }
    

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('traspaso_config');
    }
}
