<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePreventasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('preventas', function (Blueprint $table) {
            $table->id();
            
            // Claves foráneas
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('tienda_id')->constrained('ubicaciones')->onDelete('cascade');
            $table->string('nombre_cliente');
            $table->string('tel_cliente');
            $table->decimal('precio_total', 8, 2);
            $table->integer('cantidad_total');
            $table->timestamps();
        });
    
        Schema::create('detalle_preventas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('preventa_id')->constrained('preventas')->onDelete('cascade');
            $table->foreignId('producto_id')->constrained('productos')->onDelete('cascade');
            $table->integer('cantidad');
            $table->decimal('precio', 8, 2);
            $table->decimal('precio_total', 8, 2);
            $table->timestamps();
        });
    }
    
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('preventas');
    }
}
