<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductosVendidosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('productos_vendidos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('venta_id')->constrained('ventas_nueva')->onDelete('cascade');
            $table->foreignId('producto_id')->constrained('productos')->onDelete('cascade');
            $table->foreignId('ubicacion_id')->nullable()->constrained('ubicaciones')->onDelete('set null'); // Relación con ubicación
            $table->float('cantidad'); // Cantidad base ingresada
            $table->integer('cantidad_total'); // Cantidad final calculada según la medida
            $table->string('tipo_medida'); // Medida seleccionada (piezas, caja, etc.)
            $table->decimal('precio', 10, 2); // Precio unitario con tipo de cambio
            $table->decimal('precio_total', 10, 2); // Total para este producto
            $table->string('tipo_precio'); // Tipo de precio usado
            $table->timestamps();
        });
    }
    
    
    public function down()
    {
        Schema::dropIfExists('productos_vendidos');
    }
    
    
}
