<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddUsuarioAprobadorToVentasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ventas_nueva', function (Blueprint $table) {
            $table->foreignId('usuario_aprobador_id')->nullable()->constrained('users')->onDelete('set null')->after('estado');
        });
    }
    
    public function down()
    {
        Schema::table('ventas_nueva', function (Blueprint $table) {
            $table->dropForeign(['usuario_aprobador_id']);
            $table->dropColumn('usuario_aprobador_id');
        });
    }
    
}
