<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddClienteAndObservacionToVentas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ventas_nueva', function (Blueprint $table) {
            // Agregar campo cliente_id como llave foránea
            $table->foreignId('cliente_id')->nullable()->constrained('clientes')->onDelete('set null');
            
            // Agregar campo observacion
            $table->text('observacion')->nullable()->after('cliente_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ventas_nueva', function (Blueprint $table) {
            // Eliminar las columnas si se hace un rollback
            $table->dropForeign(['cliente_id']);
            $table->dropColumn('cliente_id');
            $table->dropColumn('observacion');
        });
    }
}
