<?php
namespace Database\Seeders;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;


class UsuariosRolesSeeder extends Seeder

{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Crear roles si no existen
        $adminRole = Role::firstOrCreate(['name' => 'administrador']);
        $gerenteRole = Role::firstOrCreate(['name' => 'gerente']);
        $vendedorRole = Role::firstOrCreate(['name' => 'vendedor']);
    
        // Crear permisos si no existen
        $permisosAdmin = ['admin',  'gerente','vendedor'];
        $permisosGerente = ['gerente', 'vendedor'];
        $permisosVendedor = ['vendedor'];
    
        foreach ($permisosAdmin as $permiso) {
            Permission::firstOrCreate(['name' => $permiso]);
        }
    
        foreach ($permisosGerente as $permiso) {
            Permission::firstOrCreate(['name' => $permiso]);
        }
    
        foreach ($permisosVendedor as $permiso) {
            Permission::firstOrCreate(['name' => $permiso]);
        }
    
        // Crear usuarios y asignar roles y permisos
        $admin = User::create([
            'name' => 'Admin',
            'email' => 'admin@gmail.com',
            'password' => Hash::make('12345678'),
        ]);
    
        $gerente = User::create([
            'name' => 'Gerente',
            'email' => 'gerente@gmail.com',
            'password' => Hash::make('12345678'),
        ]);
    

    
        // Asignar roles y permisos a los usuarios
        $admin->assignRole($adminRole);
        $admin->givePermissionTo($permisosAdmin);
    
        $gerente->assignRole($gerenteRole);
        $gerente->givePermissionTo($permisosGerente);

    }
    
}
