@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <div class="card shadow-sm border-0 rounded">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h2 class="mb-0">Gestión de Archivos Importados</h2>
            <a href="{{ route('mercancia.index') }}" class="btn btn-light">
                <i class="fas fa-arrow-left"></i> Volver a Mercancía
            </a>
        </div>
        <div class="card-body">
            <!-- Mensajes de éxito y error -->
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <!-- Tabla de archivos -->
            <div class="table-responsive">
                <table class="table table-striped table-bordered text-center align-middle">
                    <thead class="bg-light">
                        <tr>
                            <th>#</th>
                            <th>Nombre del Archivo</th>
                            <th>Fecha de Importación</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($archivos as $archivo)
                            <tr>
                                <td>{{ $archivo->id }}</td>
                                <td>{{ $archivo->nombre }}</td>
                                <td>{{ \Carbon\Carbon::parse($archivo->created_at)->format('d/m/Y H:i') }}</td>
                                <td>
                                    <div class="btn-group" role="group" aria-label="Acciones">
                                        <!-- Descargar archivo -->
                                        <a href="{{ route('archivos.archivos.descargar', $archivo->id) }}" class="btn btn-info btn-sm" title="Descargar">
                                            <i class="fas fa-download"></i>
                                        </a>
                                        <!-- Eliminar archivo -->
                                        <form action="{{ route('archivos.archivos.eliminar', $archivo->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" title="Eliminar Archivo">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-muted text-center">No hay archivos importados registrados.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Paginación -->
            <div class="d-flex justify-content-center mt-4">
                {{ $archivos->links() }}
            </div>
        </div>
    </div>
</div>
@endsection
