@extends('layouts.app')

@section('content')
<section class="section">
    <div class="section-header d-flex justify-content-between align-items-center">
        <h3 class="page__heading">🛒 Registro de Compras</h3>
        <a href="{{ route('compras.create') }}" class="btn btn-primary shadow">
            <i class="fas fa-plus-circle me-2"></i> Nueva Compra
        </a>
    </div>

    <!-- Filtros -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form action="{{ route('compras.index') }}" method="get" class="row align-items-end">
                <!-- Buscar por producto -->
                <div class="col-md-3 mb-3">
                    <label for="search">🔍 Buscar producto:</label>
                    <input type="text" name="search" class="form-control" placeholder="Nombre, Código o Descripción" value="{{ request('search') }}">
                </div>

                <!-- Filtrar por ubicación -->
                <div class="col-md-3 mb-3">
                    <label for="ubicacion_id">📍 Ubicación:</label>
                    <select name="ubicacion_id" class="form-control select2">
                        <option value="">Todas</option>
                        @foreach($ubicaciones as $ubicacion)
                            <option value="{{ $ubicacion->id }}" {{ request('ubicacion_id') == $ubicacion->id ? 'selected' : '' }}>
                                {{ $ubicacion->nombre }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <!-- Filtrar por período -->
                <div class="col-md-4 mb-3">
                    <label>📅 Período:</label>
                    <div class="input-group">
                        <input type="date" name="start_date" class="form-control" value="{{ request('start_date') }}">
                        <span class="input-group-text">a</span>
                        <input type="date" name="end_date" class="form-control" value="{{ request('end_date') }}">
                    </div>
                </div>

                <!-- Botones de acción -->
                <div class="col-md-2 mb-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-search me-2"></i> Filtrar
                    </button>
                </div>
            </form>

            <!-- Botones adicionales -->
            <div class="d-flex justify-content-between">
                <a href="{{ route('compras.index') }}" class="btn btn-secondary shadow">
                    <i class="fas fa-sync-alt me-2"></i> Ver Todas
                </a>

                <form action="{{ route('compras.generatePDF') }}" method="GET" class="d-flex align-items-center">
                    <input type="hidden" name="search" value="{{ request('search') }}">
                    <input type="hidden" name="ubicacion_id" value="{{ request('ubicacion_id') }}">
                    <input type="hidden" name="start_date" value="{{ request('start_date') }}">
                    <input type="hidden" name="end_date" value="{{ request('end_date') }}">
                    <button type="submit" class="btn btn-success shadow">
                        <i class="fas fa-file-pdf me-2"></i> Generar Reporte PDF
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Tabla de compras -->
    <div class="card shadow-sm">
        <div class="card-body">
            <h4 class="mb-4 text-primary">📄 Compras Registradas</h4>
            <div class="table-responsive">
                <table class="table table-hover table-bordered text-center align-middle">
                    <thead class="thead-dark">
                        <tr>
                            <th>#</th>
                            <th>Producto</th>
                            <th>Ubicación</th>
                            <th>Cantidad</th>
                            <th>Costo Total</th>
                            <th>Detalles del Producto</th>
                            <th>Usuario</th>
                            <th>Fecha y Hora</th>
                            <th>Observación</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($compras as $index => $compra)
                            <tr>
                                <td>{{ $compras->firstItem() + $index }}</td>
                                <td>{{ $compra->producto->nombre }}</td>
                                <td>{{ $compra->ubicacion->nombre }}</td>
                                <td>{{ $compra->cantidad }}</td>
                                <td>{{ number_format($compra->costo_total, 2) }} Bs.</td>
                                <td class="text-start">
                                    <p><strong>🔖 Código 1:</strong> {{ $compra->producto->codigo1 ?? 'N/A' }}</p>
                                    <p><strong>🔖 Código 2:</strong> {{ $compra->producto->codigo2 ?? 'N/A' }}</p>
                                    <p><strong>📊 Cantidad Actual:</strong> {{ $compra->producto->cantidad ?? 0 }}</p>
                                    <p><strong>📝 Descripción:</strong> {{ $compra->producto->descripcion ?? 'Sin descripción' }}</p>
                                    <p><strong>🏷 Pizas/Caja:</strong> {{ $compra->producto->piezas_por_paquete ?? 'N/A' }}</p>
                                    <p><strong>🏷 Pizas/Paquete:</strong> {{ $compra->producto->piezas_por_caja ?? 'N/A' }}</p>
                                </td>
                                <td>{{ $compra->usuario->name }}</td>
                                <td>{{ \Carbon\Carbon::parse($compra->fecha_hora)->subHours(4)->format('d/m/Y h:i A') }}</td>
                                <td>{{ $compra->observacion ?? 'N/A' }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="text-center text-muted">No hay compras registradas.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Paginación -->
            <div class="d-flex justify-content-center mt-4">
                {{ $compras->appends(request()->query())->links() }}
            </div>
        </div>
    </div>
</section>

@section('scripts')
<script>
    $(document).ready(function() {
        $('.select2').select2({
            placeholder: "Seleccione una opción",
            allowClear: true
        });
    });
</script>
@endsection
@endsection
