@extends('layouts.app')

@section('content')
<section class="section">
    <div class="section-header">
        <h3 class="page__heading">Transferencia de Productos</h3>
    </div>

    @if($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif

    <form action="{{ route('traspasos.enviarProducto') }}" method="POST">
        @csrf

        <!-- Seleccionar Sucursal de Origen -->
        <div class="form-group">
            <label for="ubicacion_origen_id">Sucursal de Origen:</label>
            <select name="ubicacion_origen_id" id="ubicacion_origen_id" class="form-control" required>
                <option value="">Seleccione una sucursal</option>
                @foreach($ubicaciones as $ubicacion)
                    <option value="{{ $ubicacion->id }}">{{ $ubicacion->nombre }}</option>
                @endforeach
            </select>
        </div>

        <!-- Seleccionar Producto -->
        <div class="form-group">
            <label for="producto_id">Producto:</label>
            <select name="producto_id" id="producto_id" class="form-control select2" required disabled>
                <option value="">Seleccione un producto</option>
            </select>
        </div>

        <!-- Campos dinámicos de producto -->
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="codigo1">Código 1:</label>
                    <input type="text" id="codigo1" class="form-control" readonly>
                </div>
                <div class="form-group">
                    <label for="codigo2">Código 2:</label>
                    <input type="text" id="codigo2" class="form-control" readonly>
                </div>
                <div class="form-group">
                    <label for="descripcion">Descripción:</label>
                    <input type="text" id="descripcion" class="form-control" readonly>
                </div>
                <div class="form-group">
                    <label for="posicion">Ubicación en Depósito:</label>
                    <input type="text" id="posicion" class="form-control" readonly>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="precio_unidad_facturado">Precio Unidad Facturado:</label>
                    <input type="text" id="precio_unidad_facturado" class="form-control" readonly>
                </div>
                <div class="form-group">
                    <label for="precio_docena_facturado">Precio Docena Facturado:</label>
                    <input type="text" id="precio_docena_facturado" class="form-control" readonly>
                </div>
                <div class="form-group">
                    <label for="precio_paquete_facturado">Precio Paquete Facturado:</label>
                    <input type="text" id="precio_paquete_facturado" class="form-control" readonly>
                </div>
                <div class="form-group">
                    <label for="precio_paquete_normal">Precio Paquete Normal:</label>
                    <input type="text" id="precio_paquete_normal" class="form-control" readonly>
                </div>
                <div class="form-group">
                    <label for="precio_docena_normal">Precio Docena Normal:</label>
                    <input type="text" id="precio_docena_normal" class="form-control" readonly>
                </div>
                <div class="form-group">
                    <label for="precio_docena_caja">Precio Docena Caja:</label>
                    <input type="text" id="precio_docena_caja" class="form-control" readonly>
                </div>
            </div>
        </div>

        <!-- Seleccionar Sucursal de Destino -->
        <div class="form-group">
            <label for="ubicacion_destino_id">Sucursal de Destino:</label>
            <select name="ubicacion_destino_id" id="ubicacion_destino_id" class="form-control" required>
                <option value="">Seleccione una sucursal</option>
                @foreach($ubicaciones as $ubicacion)
                    <option value="{{ $ubicacion->id }}">{{ $ubicacion->nombre }}</option>
                @endforeach
            </select>
        </div>

        <!-- Cantidad -->
        <div class="form-group">
            <label for="cantidad">Cantidad:</label>
            <input type="number" name="cantidad" id="cantidad" class="form-control" required disabled>
        </div>

        <button type="submit" class="btn btn-primary">Enviar Producto</button>
    </form>

    <!-- Estilos y Scripts para Select2 -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-beta.1/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-beta.1/js/select2.min.js"></script>
    
    <!-- Script -->
    <script>

$(document).ready(function () {
    const cantidadMaximaGlobal = @json(optional(\App\Models\TraspasoConfig::first())->cantidad_maxima ?? 0);

    $('.select2').select2({
        placeholder: "Seleccione un producto",
        allowClear: true,
        width: '100%'
    });

    // Al cambiar la sucursal de origen
    $('#ubicacion_origen_id').on('change', function () {
        const sucursalId = this.value;
        const productoSelect = $('#producto_id');
        const cantidadInput = $('#cantidad');

        // Limpiar los campos
        productoSelect.empty().append('<option value="">Seleccione un producto</option>').prop('disabled', true);
        cantidadInput.val('').prop('disabled', true);
        limpiarCamposProducto();

        if (sucursalId) {
            // Hacer la solicitud al endpoint
           fetch("{{ url('productos/por-ubicacion') }}/" + sucursalId)
    .then(response => {
        if (response.ok) {
            return response.json();
        }
        throw new Error('No se encontraron productos en esta sucursal.');
    })
    .then(data => {
        // Llenar el select con los productos
        if (data.length > 0) {
            data.forEach(producto => {
                const option = new Option(
                    `${producto.codigo1} / ${producto.codigo2} - ${producto.nombre} (Cantidad: ${producto.cantidad})`,
                    producto.id
                );
                $(option).data({
                    cantidad: producto.cantidad,
                    codigo1: producto.codigo1 || '',
                    codigo2: producto.codigo2 || '',
                    descripcion: producto.descripcion || '',
                    ubicacion_deposito: producto.ubicacion_deposito || '',
                    posicion: producto.posicion || '',
                    precio_unidad_facturado: producto.precio_unidad_facturado || 0,
                    precio_docena_facturado: producto.precio_docena_facturado || 0,
                    precio_paquete_facturado: producto.precio_paquete_facturado || 0,
                    precio_paquete_normal: producto.precio_paquete_normal || 0,
                    precio_docena_normal: producto.precio_docena_normal || 0,
                    precio_docena_caja: producto.precio_docena_caja || 0,
                });
                productoSelect.append(option);
            });
            productoSelect.prop('disabled', false);
        } else {
            alert('No hay productos disponibles en esta sucursal.');
        }
    })
    .catch(error => {
        alert(error.message);
    });

        }
    });

    // Al seleccionar un producto
    $('#producto_id').on('change', function () {
        const selectedOption = $(this).find(':selected');
        const cantidadDisponible = selectedOption.data('cantidad') || 0;
        const cantidadMaxima = Math.min(cantidadDisponible, cantidadMaximaGlobal);

        // Habilitar la entrada de cantidad
        $('#cantidad').attr('max', cantidadMaxima).prop('disabled', false);

        // Llenar los campos con los datos del producto
        $('#codigo1').val(selectedOption.data('codigo1'));
        $('#codigo2').val(selectedOption.data('codigo2'));
        $('#descripcion').val(selectedOption.data('descripcion'));
        $('#ubicacion_deposito').val(selectedOption.data('ubicacion_deposito'));
        $('#posicion').val(selectedOption.data('posicion'));
        $('#precio_unidad_facturado').val(selectedOption.data('precio_unidad_facturado'));
        $('#precio_docena_facturado').val(selectedOption.data('precio_docena_facturado'));
        $('#precio_paquete_facturado').val(selectedOption.data('precio_paquete_facturado'));
        $('#precio_paquete_normal').val(selectedOption.data('precio_paquete_normal'));
        $('#precio_docena_normal').val(selectedOption.data('precio_docena_normal'));
        $('#precio_docena_caja').val(selectedOption.data('precio_docena_caja'));
    });

    // Función para limpiar los campos dinámicos
    function limpiarCamposProducto() {
        $('#codigo1, #codigo2, #descripcion, #ubicacion_deposito, #posicion, #precio_unidad_facturado, #precio_docena_facturado, #precio_paquete_facturado, #precio_paquete_normal, #precio_docena_normal, #precio_docena_caja').val('');
    }
});


    </script>
</section>
@endsection
