<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resumen para Almacén</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            width: 80mm;
            margin: 0 auto;
            padding: 5mm;
            color: #333;
            text-align: left;
            box-sizing: border-box;
        }

        header {
            margin-bottom: 10px;
        }

        header h1 {
            font-size: 14px;
            margin: 0;
            color: #555;
        }

        header p {
            font-size: 10px;
            margin: 2px 0;
            color: #666;
        }

        .venta-info, .producto-info {
            margin-bottom: 10px;
            text-align: left;
        }

        .venta-info p, .producto-info p {
            margin: 3px 0;
            line-height: 1.2;
        }

        .separator {
            border-bottom: 1px dashed #aaa;
            margin: 5px 0;
        }

        .footer-info {
            margin-top: 10px;
            font-size: 9px;
            text-align: left;
            margin-right: 10px;
        }

        .footer-info p {
            margin: 3px 0;
        }

        .footer-info strong {
            font-size: 10px;
        }

        .observaciones {
            text-align: left;
            margin-top: 20px;
        }

        .observaciones p {
            margin: 0;
        }

        .observaciones strong {
            margin-right: 5px;
        }
    </style>
</head>
<body>
    <header>
        <h1>Resumen para Almacén</h1>
        <p>Generado el: {{ now()->subHours(4)->format('d/m/Y H:i:s') }}</p>
    </header>

    <div class="venta-info">
        <p><strong>Código de Venta:</strong> {{ $venta->codigo }}</p>
        <p><strong>Usuario que generó la venta:</strong> {{ $venta->usuario->name }}</p>
        <p><strong>Usuario que aprobó la venta:</strong> {{ $venta->usuarioAprobador->name }}</p>
    </div>

    <div class="separator"></div>
    @foreach($venta->productosVendidos as $productoVendido)
    @php
    $producto = $productoVendido->producto;
    $restante = $producto->cantidad ;
@endphp

<div class="producto-info">
    <p><strong>Código:</strong> {{ $producto->codigo1 }}</p>
    <p><strong>Producto:</strong> {{ $producto->nombre }}</p>
    <p><strong>Descripción:</strong> {{ $producto->descripcion }}</p>
    <p><strong>Posición:</strong> {{ $producto->posicion }}</p>
    <p><strong>Cantidad Vendida:</strong> {{ $productoVendido->cantidad_total }}</p>
    <p><strong>Cantidad Restante:</strong> {{ $restante }}</p>
</div>
<div class="separator"></div>
@endforeach


    <div class="footer-info">
        <p><strong>Nota:</strong> Este resumen es únicamente para uso interno </p>
    <p>del almacén y debe manejarse con confidencialidad.</p>
    </div>

    <div class="observaciones">
        <p><strong>Observaciones:</strong> {{ $venta->observacion ?? '__________________________' }}</p>
    </div>
</body>
</html>
