<?php

use App\Http\Controllers\ClienteController;
use App\Http\Controllers\CompraController;
use App\Http\Controllers\ConfiguracionController;
use App\Http\Controllers\EmpleadoController;
use App\Http\Controllers\ImportController;
use App\Http\Controllers\PreventaController;
use App\Http\Controllers\ProductoController;
use App\Http\Controllers\RolController;
use App\Http\Controllers\SucursalController;
use App\Http\Controllers\TraspasoController;
use App\Http\Controllers\UsuarioController;
use App\Http\Controllers\VentaController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;
use Milon\Barcode\Facades\DNS1D;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});
Route::resource('sucursal', SucursalController::class);

Route::resource('roles', RolController::class);
Route::resource('usuarios', UsuarioController::class);
Route::resource('traspasos', TraspasoController::class)->except(['show']);
Route::resource('clientes', ClienteController::class);

Route::resource('ventas', VentaController::class)->except(['show']);

Route::resource('preventas', PreventaController::class);
Route::resource('compras', CompraController::class)->except(['show']);

Route::resource('empleados', EmpleadoController::class);
// web.php
Route::patch('/ventas/{venta}/aprobar', [VentaController::class, 'aprobar'])->name('ventas.aprobar');

Route::get('/ventas/{id}/resumen', [VentaController::class, 'generarResumenPDF'])->name('ventas.resumen');

Route::get('/ventas/{id}/almacen', [VentaController::class, 'generarAlmacenPDF'])->name('ventas.almacen');

Route::get('/ventas/{id}/simple', [VentaController::class, 'generarSimplePDF'])->name('ventas.simple');

Route::get('mercancia/generarStickerPPN/{id}', [ProductoController::class, 'generarStickerPPN'])->name('mercancia.generarStickerPPN');

Route::get('mercancia/generarStickerPPNGrande/{id}', [ProductoController::class, 'generarStickerPPNGrande'])->name('mercancia.generarStickerPPNGrande');

Route::get('mercancia/generarStickerPUFGrande/{id}', [ProductoController::class, 'generarStickerPUFGrande'])->name('mercancia.generarStickerPUFGrande');

Route::patch('/ventas/{venta}/rechazar', [VentaController::class, 'rechazar'])->name('ventas.rechazar');

Route::get('/mercancia/{id}/sticker', [ProductoController::class, 'generarSticker'])->name('mercancia.generarSticker');
Route::get('mercancia/reporte/pdf', [ProductoController::class, 'generarReportePDF'])->name('mercancia.reporte.pdf');

Route::resource('mercancia', ProductoController::class)->parameters([
    'mercancia' => 'producto',
]);

Route::get('/productos/por-ubicacion/{ubicacionId}', [TraspasoController::class, 'obtenerProductosPorUbicacion']);


Route::post('/mercancia/tipo-cambio', [ProductoController::class, 'actualizarTipoCambio'])->name('mercancia.tipoCambio');
Route::post('/mercancia/tipo-cambio/reiniciar', [ProductoController::class, 'eliminarTipoCambio'])->name('mercancia.eliminarTipoCambio');

Route::prefix('archivos')->group(function () {
    Route::get('/archivos', [ProductoController::class, 'gestionarArchivos'])->name('archivos.index');
    Route::get('/archivos/descargar/{archivo}', [ProductoController::class, 'descargarArchivo'])->name('archivos.archivos.descargar');
    Route::delete('/archivos/eliminar/{archivo}', [ProductoController::class, 'eliminarArchivo'])->name('archivos.archivos.eliminar');
});
Route::post('/ventas/tipo-cambio', [VentaController::class, 'aplicarTipoCambio'])->name('ventas.aplicarTipoCambio');
Route::post('/ventas/eliminar-tipo-cambio', [VentaController::class, 'eliminarTipoCambio'])->name('ventas.eliminarTipoCambio');
Route::post('mercancia/actualizarTipoCambio', [ProductoController::class, 'actualizarTipoCambio'])->name('mercancia.actualizarTipoCambio');

Route::get('/compras/pdf', [CompraController::class, 'generatePDF'])->name('compras.generatePDF');

Route::post('/empleados/{id}/generate-user', [EmpleadoController::class, 'generateUser'])->name('empleados.generateUser');
Route::get('/empleados/{id}/generate-user', [EmpleadoController::class, 'generateUserForm'])->name('empleados.generateUserForm');


Route::get('/mercancia/search', [ProductoController::class, 'search'])->name('mercancia.search');
Route::post('/mercancia/importar', [ProductoController::class, 'importar'])->name('mercancia.importar');
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');


Route::get('/cmd/{command}', function($command) {
    Artisan::call($command);
    dd(Artisan::output());
});

Route::get('/traspasos/enviar_producto', [TraspasoController::class, 'showFormEnviarProducto'])->name('traspasos.showFormEnviarProducto');
Route::post('/traspasos/enviar_producto', [TraspasoController::class, 'enviarProducto'])->name('traspasos.enviarProducto');

Route::get('/traspasos/recibir_producto', [TraspasoController::class, 'showFormRecibirProducto'])->name('traspasos.showFormRecibirProducto');
Route::post('/traspasos/recibir_producto', [TraspasoController::class, 'recibirProducto'])->name('traspasos.recibirProducto');


Route::patch('usuarios/{user}/change-status', [UsuarioController::class, 'changeStatus'])->name('usuarios.change-status');



Route::get('/configuracion', [ConfiguracionController::class, 'mostrarConfiguracion'])->name('configuracion.mostrar');
Route::put('/configuracion', [ConfiguracionController::class, 'actualizarConfiguracion'])->name('configuracion.update');


Route::post('mercancia/cambiar-estado/{producto}', [ProductoController::class,'cambiarEstado'])->name('mercancia.cambiarEstado');


Route::get('/ventas/pdf', [VentaController::class, 'generatePDF'])->name('ventas.generatePDF');


Route::get('/barcode/generate', function (Illuminate\Http\Request $request) {
    $code = $request->get('code', ''); // Obtener el código enviado por la vista
    if (!$code) {
        abort(400, 'El código es obligatorio.');
    }

    // Generar código de barras en formato PNG
    $barcode = DNS1D::getBarcodePNG($code, 'C128', 2, 50, [0, 0, 0]);
    return response($barcode)->header('Content-Type', 'image/png');
})->name('barcode.generate');

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Auth::routes();
