

<?php $__env->startSection('content'); ?>
<section class="section">
    <div class="section-header">
        <h3 class="page__heading text-primary">🛒 Realizar Venta</h3>
    </div>

    <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <div class="row">
        <!-- Selección de Producto e Información -->
        <div class="col-lg-6">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">📋 Selección de Producto</h5>
                </div>
                <div class="card-body">
                    <!-- Selección de Producto -->
                    <div class="form-group">
                        <label for="productoSelect">📦 Producto:</label>
                        <select name="producto_id" class="form-control select2" id="productoSelect" required>
                            <option value="" disabled selected>Selecciona un producto</option>
                            <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($producto->cantidad > 0 && $producto->estado == 'activo'): ?>
                                    <option value="<?php echo e($producto->id); ?>"><?php echo e($producto->nombre); ?> - <?php echo e($producto->codigo1); ?></option>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Imagen del Producto -->
                    <div class="text-center my-4">
                        <img id="productoImg" src="<?php echo e(asset('img/logo.png')); ?>" class="img-fluid rounded shadow-sm" alt="Imagen del producto" style="max-height: 200px; cursor: pointer;" onclick="showImagePopup(this.src)">
                    </div>

                    <!-- Cuadro Emergente Personalizado -->
                    <div id="imagePopup" class="image-popup" style="display: none;">
                        <div class="popup-content">
                            <img id="popupImg" src="" class="img-fluid" alt="Producto">
                            <button class="btn btn-secondary" onclick="closeImagePopup()">Cerrar</button>
                        </div>
                    </div>
<!-- Detalles del Producto -->
<h6 class="text-primary mb-3">💰 Detalles del Producto:</h6>
<ul class="list-group mb-4">
    <li class="list-group-item"><strong>Cantidad de Producto:</strong> <span id="cantidadProducto">0</span></li>
    <li class="list-group-item"><strong>Posición:</strong> <span id="posicion">N/A</span></li>
    <li class="list-group-item"><strong>Marca:</strong> <span id="marca">N/A</span></li>
    <li class="list-group-item"><strong>Descripción:</strong> <span id="descripcion">N/A</span></li>
    
    <li class="list-group-item">Precio unidad facturado  <strong>PUF:</strong> <span id="puf">0.00</span> Bs.</li>
    <li class="list-group-item">Precio docena facturado <strong>PDF:</strong> <span id="pdf">0.00</span> Bs.</li>
    <li class="list-group-item">Precio paquete facturado <strong>PPF:</strong> <span id="ppf">0.00</span> Bs.</li>
    <li class="list-group-item">Precio paquete normal <strong>PPN:</strong>  <span id="ppn">0.00</span> Bs.</li>
    <li class="list-group-item">Precio docena normal <strong>PDN:</strong> <span id="pdn">0.00</span> Bs.</li>
    <li class="list-group-item">Precio docena por caja <strong>PDC:</strong>  <span id="pdc">0.00</span> Bs.</li>

    <!-- Nuevas filas para Piezas por paquete y Piezas por caja -->
    <li class="list-group-item"><strong>Piezas por Paquete:</strong> <span id="piezasPorPaquete">0</span></li>
    <li class="list-group-item"><strong>Piezas por Caja:</strong> <span id="piezasPorCaja">0</span></li>
</ul>


                    <!-- Formulario para Agregar Producto -->
                    <form id="productoDetalles">
                        <div class="form-group">
                            <label for="tipoPrecio">💰 Tipo de Precio:</label>
                            <select id="tipoPrecio" class="form-control" required>
                                <option value="" disabled selected>Selecciona un tipo de precio</option>
                                <option value="PUF">PUF</option>
                                <option value="PDF">PDF</option>
                                <option value="PPF">PPF</option>
                                <option value="PPN">PPN</option>
                                <option value="PDN">PDN</option>
                                <option value="PDC">PDC</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="medida">📏 Unidad de medida:</label>
                            <select id="medida" class="form-control" required>
                                <option value="" disabled selected>Selecciona una medida</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="cantidadInput">📊 Cantidad:</label>
                            <input type="text" name="cantidad" id="cantidadInput" class="form-control" required>
                        </div>
                        <button type="button" class="btn btn-primary btn-block" id="agregarProducto">➕ Agregar Producto</button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Resumen de Productos -->
        <div class="col-lg-6">
            <form action="<?php echo e(route('ventas.store')); ?>" method="POST" id="ventaForm">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="precio_total" id="precioTotalHidden" value="0">
                <input type="hidden" name="productos" id="productosInput" value="[]">
                <div class="form-group">
                    <label for="clienteSelect">👤 Cliente:</label>
                    <select name="cliente_id" class="form-control select2" id="clienteSelect" required>
                        <option value="" disabled selected>Selecciona un cliente</option>
                        <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($cliente->id); ?>"><?php echo e($cliente->nombre); ?> - <?php echo e($cliente->apellidos); ?> - <?php echo e($cliente->carnet); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Nuevo campo Observación -->
                <div class="form-group">
                    <label for="observacion">📝 Observación:</label>
                    <textarea name="observacion" id="observacion" class="form-control" rows="3"></textarea>
                </div>
                <div class="card shadow-sm">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0">🛍 Resumen de Productos</h5>
                    </div>
                    <div class="card-body table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Producto</th>
                                    <th>Descripcion</th>
                                    <th>Codigo 1</th>
                                    <th>Ubicación</th>
                                    <th>Tipo de Precio</th>
                                    <th>Precio</th>
                                    <th>Medida</th>
                                    <th>Cantidad</th>
                                    <th>Precio Unitario</th>
                                    <th>Cantidad Total</th>
                                    <th>Total</th>
                                    <th>Acción</th>
                                </tr>
                            </thead>
                            <tbody id="productosList"></tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="8" class="text-right"><strong>Total Venta:</strong></td>
                                    <td><span id="precioTotal">0.00</span> Bs.</td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                        <button type="submit" class="btn btn-success btn-block mt-3" id="realizarVenta" style="display:none;">✅ Realizar Venta</button>
                    </div>
                </div>
            </form>
            
        </div>
    </div>
</section>
<script>
    // Activar Select2 en el campo cliente_id
    $(document).ready(function() {
        $('.select2').select2(); // Inicializa Select2
    });
</script>

<script>
    // Mostrar cuadro emergente personalizado para imágenes
    function showImagePopup(src) {
        const popup = document.getElementById('imagePopup');
        const popupImg = document.getElementById('popupImg');
        popupImg.src = src;
        popup.style.display = 'block';
    }

    // Cerrar cuadro emergente personalizado
    function closeImagePopup() {
        const popup = document.getElementById('imagePopup');
        popup.style.display = 'none';
    }

    document.addEventListener('DOMContentLoaded', () => {
        const productosData = <?php echo json_encode($productos->keyBy('id'), 15, 512) ?>;
        const tipoCambio = <?php echo json_encode($tipoCambio, 15, 512) ?>;

        // Inicializar Select2 para la selección de productos
        $('#productoSelect').select2();

        // Cambio en la selección de producto
        $('#productoSelect').on('change', function () {
            const productoId = $(this).val();
            const producto = productosData[productoId];

            if (!producto) return;

       // Actualizar imagen del producto
$('#productoImg').attr('src', producto.foto ? `<?php echo e(asset('storage/')); ?>/${producto.foto}` : '<?php echo e(asset("img/logo.png")); ?>');
            // Actualizar detalles del producto
            $('#cantidadProducto').text(producto.cantidad);
            $('#posicion').text(producto.posicion || 'N/A');
            $('#marca').text(producto.marca || 'N/A');
            $('#descripcion').text(producto.descripcion || 'N/A');

            // Actualizar precios
            $('#puf').text((producto.precio_unidad_facturado * tipoCambio).toFixed(2));
            $('#pdf').text((producto.precio_docena_facturado * tipoCambio).toFixed(2));
            $('#ppf').text((producto.precio_paquete_facturado * tipoCambio).toFixed(2));
            $('#ppn').text((producto.precio_paquete_normal * tipoCambio).toFixed(2));
            $('#pdn').text((producto.precio_docena_normal * tipoCambio).toFixed(2));
            $('#pdc').text((producto.precio_docena_caja * tipoCambio).toFixed(2));

            // Actualizar Piezas por paquete y piezas por caja
            $('#piezasPorPaquete').text(producto.piezas_por_paquete || '0');
            $('#piezasPorCaja').text(producto.piezas_por_caja || '0');

            // Actualizar opciones de unidad de medida
            $('#medida').html(`
                <option value="" disabled selected>Selecciona una medida</option>
                <option value="piezas" data-unidades="1">Piezas</option>
            `);
            if (producto.docena) {
                $('#medida').append(`
                    <option value="cuarta" data-unidades="3">Cuarta</option>
                    <option value="media_docena" data-unidades="6">Media Docena</option>
                    <option value="docena" data-unidades="12">Docena</option>
                `);
            }
            $('#medida').append(`
                <option value="paquetes" data-unidades="${producto.piezas_por_paquete}">Paquetes</option>
                <option value="cajas" data-unidades="${producto.piezas_por_caja}">Cajas</option>
            `);
        });

        // Validación de cantidad según la medida seleccionada
        $('#medida').on('change', function () {
            const medida = $(this).val();
            const cantidadInput = $('#cantidadInput');

            if (medida === 'cajas') {
                cantidadInput.attr('pattern', '^[0-9]+(\\.5)?$');
                cantidadInput.attr('title', 'La cantidad debe ser múltiplo de 0.5');
            } else {
                cantidadInput.attr('pattern', '^[0-9]+$');
                cantidadInput.attr('title', 'La cantidad debe ser un número entero');
            }
        });

        function updateProductosInput() {
            const productos = [];
            $('#productosList tr').each(function () {
                const fila = $(this);
                const producto = {
                    id: fila.data('producto-id'),
                    descripcion: fila.find('td:nth-child(2)').text(),
                    codigo1: fila.find('td:nth-child(3)').text(),
                    ubicacion: fila.find('td:nth-child(4)').text(),
                    tipo_precio: fila.find('td:nth-child(5)').text(),
                    precio: parseFloat(fila.find('td:nth-child(6)').text()),
                    tipo_medida: fila.find('td:nth-child(7)').text(),
                    cantidad: parseFloat(fila.find('td:nth-child(8)').text()),
                    cantidad_total: parseFloat(fila.find('td:nth-child(10)').text()),
                    precio_total: parseFloat(fila.find('td:nth-child(11)').text()),
                };
                productos.push(producto);
            });
            console.log(productos); // Debug
            $('#productosInput').val(JSON.stringify(productos));
        }

        // Agregar producto al resumen
        $('#agregarProducto').on('click', function () {
            const productoId = $('#productoSelect').val();
            const producto = productosData[productoId];
            const tipoPrecio = $('#tipoPrecio').val();
            const medidaSeleccionada = $('#medida').find(':selected');
            const cantidad = parseFloat($('#cantidadInput').val());

            if (!producto || !tipoPrecio || !medidaSeleccionada.val() || !cantidad) {
                alert('Completa todos los campos para agregar un producto.');
                return;
            }

            const medida = medidaSeleccionada.val();
            const unidadesPorMedida = parseInt(medidaSeleccionada.data('unidades')) || 1;
            const cantidadTotal = cantidad * unidadesPorMedida;

            // Obtener el precio según el tipo de precio seleccionado
            const precio = parseFloat($(`#${tipoPrecio.toLowerCase()}`).text()) || 0;

            // Calcular el precio unitario basado en el tipo de precio
            let precioUnitario = precio;
            switch (tipoPrecio) {
                case 'PDF':
                    precioUnitario /= 12;
                    break;
                case 'PPF':
                    precioUnitario /= producto.piezas_por_paquete;
                    break;
                case 'PPN':
                    precioUnitario /= producto.piezas_por_paquete;
                    break;
                case 'PDN':
                case 'PDC':
                    precioUnitario /= 12;
                    break;
            }

            // Calcular el total del producto
            const totalProducto = cantidadTotal * precioUnitario;

            if (cantidadTotal > producto.cantidad) {
                alert(`No hay suficiente stock para el producto seleccionado. Stock disponible: ${producto.cantidad}`);
                return;
            }

            const fila = `
            <tr data-producto-id="${productoId}">
                <td>${producto.nombre}</td>
                <td>${producto.descripcion}</td>
                <td>${producto.codigo1}</td>
                <td>${producto.ubicacion.nombre || 'Sin Ubicación'}</td>
                <td>${tipoPrecio}</td>
                <td>${precio.toFixed(2)} Bs.</td>
                <td>${medidaSeleccionada.text()}</td>
                <td>${cantidad}</td>
                <td>${precioUnitario.toFixed(2)} Bs.</td>
                <td>${cantidadTotal.toFixed(2)}</td>
                <td>${totalProducto.toFixed(2)} Bs.</td>
                <td><button type="button" class="btn btn-danger btn-sm eliminarProducto">❌</button></td>
            </tr>
        `;

            $('#productosList').append(fila);

            const nuevoTotal = parseFloat($('#precioTotalHidden').val()) + totalProducto;
            $('#precioTotalHidden').val(nuevoTotal.toFixed(2));
            $('#precioTotal').text(nuevoTotal.toFixed(2));
            $('#realizarVenta').show();

            updateProductosInput();
        });

        // Eliminar producto del resumen
        $(document).on('click', '.eliminarProducto', function () {
    const fila = $(this).closest('tr');
    const totalProducto = parseFloat(fila.find('td:nth-child(11)').text()); // Asegúrate de que la columna del total sea la correcta
    let totalActual = parseFloat($('#precioTotalHidden').val()) - totalProducto;

    totalActual = Math.max(totalActual, 0);

    $('#precioTotalHidden').val(totalActual.toFixed(2));
    $('#precioTotal').text(totalActual.toFixed(2));
    fila.remove();

    if ($('#productosList').children().length === 0) {
        $('#realizarVenta').hide();
    }

    updateProductosInput();
});   
    });
</script>




<style>
    .image-popup {
        position: fixed;
        top: 70px;
        left: 0;
        width:120%;
        height: 120%;
        background: rgba(0, 0, 0, 0.8);
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 1050;
    }

    .popup-content {
        background: rgb(144, 168, 212);
        padding: 20px;
        border-radius: 5px;
        text-align: center;
    }

    .popup-content img {
        max-width: 100%;
        height: auto;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/offsides/public_html/resources/views/ventas/create.blade.php ENDPATH**/ ?>