

<?php $__env->startSection('content'); ?>
<section class="section">
    <div class="section-header">
        <h3 class="page__heading">Realizar Preventa</h3>
    </div>

    <?php if(session('error')): ?>
        <div class="alert alert-danger">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-6">
            <form action="<?php echo e(route('preventas.store')); ?>" method="post" id="preventaForm">
                <?php echo csrf_field(); ?>
                <!-- Campo oculto para la ubicación -->
                <input type="hidden" name="ubicacion_id" value="<?php echo e($ubicaciones->first()->id); ?>">
                <!-- Información del cliente -->
                <div class="form-group">
                    <label for="nombre_cliente">Nombre del cliente:</label>
                    <input type="text" name="nombre_cliente" class="form-control" id="nombreClienteInput" required>
                </div>
                <div class="form-group">
                    <label for="tel_cliente">Teléfono del cliente:</label>
                    <input type="tel" name="tel_cliente" class="form-control" id="telClienteInput" required>
                </div>
                <!-- Campos ocultos para totales -->
                <input type="hidden" name="precio_total" id="precioTotalInput" value="0">
                <input type="hidden" name="cantidad_total" id="cantidadTotalInput" value="0">
                <!-- Inputs dinámicos para productos -->
                <div id="productosInput"></div>
                <!-- Tabla de productos seleccionados -->
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Producto</th>
                            <th>Tipo de Precio</th>
                            <th>Precio</th>
                            <th>Cantidad</th>
                            <th>Total</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody id="productosList"></tbody>
                    <tfoot>
                        <tr>
                            <td colspan="4" class="text-right"><strong>Total:</strong></td>
                            <td colspan="2"><span id="precioTotal">0.00</span></td>
                        </tr>
                    </tfoot>
                </table>
                <!-- Botón para realizar preventa -->
                <button type="submit" class="btn btn-success w-100" id="realizarPreventaBtn" style="display: none;">Realizar Preventa</button>
            </form>
        </div>
        <div class="col-md-6">
            <!-- Selección de producto -->
            <div class="form-group">
                <label for="producto_id">Producto:</label>
                <select name="producto_id" class="form-control select2" id="productoSelect" required>
                    <option value="" disabled selected>Selecciona un producto</option>
                    <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($producto->id); ?>" 
                                data-precio1="<?php echo e($producto->precio2); ?>" 
                                data-precio2="<?php echo e($producto->precio3); ?>" 
                                data-cantidad="<?php echo e($producto->cantidad); ?>">
                            <?php echo e($producto->nombre); ?> (Cód1: <?php echo e($producto->codigo1); ?>, Cód2: <?php echo e($producto->codigo2); ?>, Stock: <?php echo e($producto->cantidad); ?>, Ubicación: <?php echo e($producto->ubicacion->nombre); ?>)
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <!-- Selección de tipo de precio -->
            <div class="form-group">
                <label for="precio">Tipo de Precio:</label>
                <select name="precio" class="form-control" id="precioSelect" required>
                    <option value="" disabled selected>Selecciona un tipo de precio</option>
                    <option value="precio1">Precio Regular</option>
                    <option value="precio2">Precio en Oferta</option>
                </select>
            </div>
            <!-- Selección de cantidad -->
            <div class="form-group">
                <label for="cantidad">Cantidad:</label>
                <input type="number" name="cantidad" class="form-control" id="cantidadInput" min="1" required>
            </div>
            <!-- Botón para agregar producto -->
            <button type="button" class="btn btn-primary w-100" id="agregarProducto">Agregar Producto</button>
        </div>
    </div>
</section>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const tipoCambio = <?php echo e($tipoCambio); ?>;
        const productoSelect = document.getElementById('productoSelect');
        const cantidadInput = document.getElementById('cantidadInput');
        const productosListBody = document.getElementById('productosList');
        const productosInput = document.getElementById('productosInput');
        const precioTotalSpan = document.getElementById('precioTotal');
        const realizarPreventaBtn = document.getElementById('realizarPreventaBtn');
        const precioTotalInput = document.getElementById('precioTotalInput');
        const cantidadTotalInput = document.getElementById('cantidadTotalInput');

        let productosAgregados = [];

        // Agregar producto a la lista
        document.getElementById('agregarProducto').addEventListener('click', function () {
            const selectedProduct = productoSelect.options[productoSelect.selectedIndex];
            const precioSeleccionado = document.getElementById('precioSelect').value;
            const cantidad = parseInt(cantidadInput.value);

            if (!selectedProduct || !precioSeleccionado || cantidad <= 0) {
                alert('Completa todos los campos antes de agregar un producto.');
                return;
            }

            const precioOriginal = parseFloat(selectedProduct.getAttribute(`data-${precioSeleccionado}`));
            const tipoPrecio = precioSeleccionado === 'precio1' ? 'Regular' : 'Oferta';
            const precioConCambio = precioOriginal * tipoCambio;
            const total = precioConCambio * cantidad;

            productosAgregados.push({
                id: selectedProduct.value,
                nombre: selectedProduct.text,
                cantidad: cantidad,
                precio: precioConCambio,
                total: total,
                tipo_precio: tipoPrecio
            });

            actualizarTablaProductos();
        });

        function actualizarTablaProductos() {
            productosListBody.innerHTML = '';
            productosInput.innerHTML = '';

            let totalGlobal = 0;
            let totalCantidad = 0;

            productosAgregados.forEach((producto, index) => {
                totalGlobal += producto.total;
                totalCantidad += producto.cantidad;

                productosListBody.innerHTML += `
                    <tr>
                        <td>${producto.nombre}</td>
                        <td>${producto.tipo_precio}</td>
                        <td>${producto.precio.toFixed(2)}</td>
                        <td>${producto.cantidad}</td>
                        <td>${producto.total.toFixed(2)}</td>
                        <td>
                            <button type="button" class="btn btn-danger btn-sm" onclick="eliminarProducto(${index})">Eliminar</button>
                        </td>
                    </tr>
                `;

                productosInput.innerHTML += `
                    <input type="hidden" name="productos[${index}][id]" value="${producto.id}">
                    <input type="hidden" name="productos[${index}][cantidad]" value="${producto.cantidad}">
                    <input type="hidden" name="productos[${index}][precio]" value="${producto.precio.toFixed(2)}">
                    <input type="hidden" name="productos[${index}][tipo_precio]" value="${producto.tipo_precio}">
                `;
            });

            precioTotalSpan.textContent = totalGlobal.toFixed(2);
            precioTotalInput.value = totalGlobal.toFixed(2);
            cantidadTotalInput.value = totalCantidad;

            realizarPreventaBtn.style.display = productosAgregados.length > 0 ? 'block' : 'none';
        }

        window.eliminarProducto = function (index) {
            productosAgregados.splice(index, 1);
            actualizarTablaProductos();
        };
    });
</script>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2({
                theme: 'classic',
                placeholder: 'Selecciona una opción',
                allowClear: true,
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\jugueteria\resources\views/preventas/create.blade.php ENDPATH**/ ?>