

<?php $__env->startSection('content'); ?>
<section class="section">
    <!-- Encabezado -->
    <div class="section-header d-flex justify-content-between align-items-center">
        <h3 class="page__heading">🛒 Gestión de Ventas</h3>
        <a href="<?php echo e(route('ventas.create')); ?>" class="btn btn-primary shadow">➕ Realizar Venta</a>
    </div>
 <!-- Recursos SweetAlert2 -->
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <!-- Mensajes -->
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    <?php if($errors->any()): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('administrador')): ?>
 <!-- Filtros de búsqueda -->
<div class="card shadow-sm mb-4">
    <div class="card-body">
        <h5 class="card-title">🔍 Filtros de búsqueda</h5>
        <form action="<?php echo e(route('ventas.index')); ?>" method="get">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="search">Buscar por Código o Producto:</label>
                    <input type="text" name="search" class="form-control" placeholder="Código, nombre o descripción" value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-3">
                    <label for="cliente">Buscar por Cliente:</label>
                    <input type="text" name="cliente" class="form-control" placeholder="Nombre, Apellido o Carnet" value="<?php echo e(request('cliente')); ?>">
                </div>
                <div class="col-md-3">
                    <label for="user_id">Filtrar por Vendedor:</label>
                    <select name="user_id" id="user_id" class="select2 form-control">
                        <option value="">Seleccionar vendedor</option>
                        <?php $__currentLoopData = $usuariosAprobadores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usuario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($usuario->id); ?>" <?php echo e(request('user_id') == $usuario->id ? 'selected' : ''); ?>>
                                <?php echo e($usuario->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label>Periodo de fechas:</label>
                    <div class="input-group">
                        <input type="date" name="start_date" class="form-control" value="<?php echo e(request('start_date')); ?>">
                        <span class="input-group-text">a</span>
                        <input type="date" name="end_date" class="form-control" value="<?php echo e(request('end_date')); ?>">
                    </div>
                </div>
                <div class="col-md-3">
                    <label for="ubicacion">Ubicación:</label>
                    <select name="ubicacion" id="ubicacion" class="form-control">
                        <option value="">Todas</option>
                        <?php $__currentLoopData = $ubicaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ubicacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($ubicacion->id); ?>" <?php echo e(request('ubicacion') == $ubicacion->id ? 'selected' : ''); ?>>
                                <?php echo e($ubicacion->nombre); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="estado">Estado:</label>
                    <select name="estado" id="estado" class="form-control">
                        <option value="">Todos</option>
                        <option value="0" <?php echo e(request('estado') == '0' ? 'selected' : ''); ?>>Pendiente</option>
                        <option value="1" <?php echo e(request('estado') == '1' ? 'selected' : ''); ?>>Aprobada</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="usuario_aprobador">Usuario Aprobador:</label>
                    <select name="usuario_aprobador" id="usuario_aprobador" class="select2 form-control">
                        <option value="">Seleccionar Aprobador</option>
                        <?php $__currentLoopData = $usuariosAprobadores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usuario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($usuario->id); ?>" <?php echo e(request('usuario_aprobador') == $usuario->id ? 'selected' : ''); ?>>
                                <?php echo e($usuario->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary mx-2">🔎 Buscar</button>
                    <a href="<?php echo e(route('ventas.index')); ?>" class="btn btn-secondary">🔄 Reiniciar</a>
                </div>
            </div>
        </form>
    </div>
    <div class="card-body">
        <h5 class="card-title">📥 Descargar reporte</h5>
        <form action="<?php echo e(route('ventas.generatePDF')); ?>" method="get" class="d-flex align-items-center">
            <?php echo csrf_field(); ?>
            <!-- Pasar filtros al reporte -->
            <input type="hidden" name="search" value="<?php echo e(request('search')); ?>">
            <input type="hidden" name="cliente" value="<?php echo e(request('cliente')); ?>">
            <input type="hidden" name="user_id" value="<?php echo e(request('user_id')); ?>">
            <input type="hidden" name="start_date" value="<?php echo e(request('start_date')); ?>">
            <input type="hidden" name="end_date" value="<?php echo e(request('end_date')); ?>">
            <input type="hidden" name="estado" value="<?php echo e(request('estado')); ?>">
            <input type="hidden" name="ubicacion" value="<?php echo e(request('ubicacion')); ?>">
            <input type="hidden" name="usuario_aprobador" value="<?php echo e(request('usuario_aprobador')); ?>">
            <input type="text" name="pdfName" class="form-control w-50" placeholder="Nombre del PDF">
            <button type="submit" class="btn btn-success ms-3">📥 Descargar PDF</button>
        </form>
    </div>
</div>

<?php endif; ?>


    <!-- Lista de Ventas -->
<div class="row">
    <?php $__empty_1 = true; $__currentLoopData = $ventasPaginadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="col-md-12">
            <div class="card shadow-sm mb-4">
                <div class="card-header d-flex justify-content-between align-items-center" 
                    style="background-color: 
                        <?php if($venta->estado == 1): ?> 
                            #28a745 
                        <?php elseif($venta->estado == 2): ?>
                            #dc3545
                        <?php else: ?>
                            #ffc107
                        <?php endif; ?>; color: white;">
                    <h6 class="mb-0">🛒 Código: <?php echo e($venta->codigo); ?></h6>
                    <span>
                        <strong>Total: <?php echo e(number_format($venta->precio_total, 2)); ?> Bs.</strong> 
                        <span class="badge 
                            <?php if($venta->estado == 1): ?> 
                                bg-success 
                            <?php elseif($venta->estado == 2): ?> 
                                bg-danger
                            <?php else: ?>
                                bg-warning text-dark
                            <?php endif; ?>">
                            <?php if($venta->estado == 1): ?> 
                                Aprobada 
                            <?php elseif($venta->estado == 2): ?> 
                                Rechazada
                            <?php else: ?> 
                                Pendiente
                            <?php endif; ?>
                        </span>
                    </span>
                </div>
                <div class="card-body">
                    <!-- Detalles de la venta -->
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <p><strong>Usuario:</strong> <?php echo e($venta->usuario->name); ?></p>
                            <p><strong>Estado:</strong> 
                                <?php if($venta->estado == 1): ?>
                                    Aprobada
                                <?php elseif($venta->estado == 2): ?>
                                    Rechazada
                                <?php else: ?>
                                    Pendiente
                                <?php endif; ?>
                            </p>
                            <p><strong>Fecha:</strong> <?php echo e(\Carbon\Carbon::parse($venta->fecha)->format('d/m/Y')); ?></p>
                            <p><strong>Hora:</strong> <?php echo e(\Carbon\Carbon::parse($venta->hora)->subHours(4)->format('H:i:s')); ?></p>
                            <p><strong>Ubicación:</strong> 
                                <?php echo e($venta->productosVendidos->pluck('producto.ubicacion.nombre')->unique()->implode(', ') ?? 'No especificada'); ?>

                            </p>
                            <?php if($venta->estado == 1 && $venta->usuarioAprobador): ?>
                                <p><strong>Aprobada por:</strong> <?php echo e($venta->usuarioAprobador->name); ?></p>
                            <?php endif; ?>
                            <?php if($venta->estado == 2 && $venta->usuarioRechazador): ?>
                                <p><strong>Rechazada por:</strong> <?php echo e($venta->usuarioRechazador->name); ?></p>
                            <?php endif; ?>
                            <?php if($venta->estado == 2): ?>
                            <p><strong>Fecha de rechazo:</strong> 
                                <?php echo e(\Carbon\Carbon::parse($venta->updated_at)->subHours(4)->format('d/m/Y H:i:s')); ?>

                            </p>
                        <?php endif; ?>
                        <?php if($venta->cliente): ?>
                        <p><strong>Cliente:</strong> <?php echo e($venta->cliente->nombre); ?> <?php echo e($venta->cliente->apellidos); ?></p>
                        <p><strong>Carnet:</strong> <?php echo e($venta->cliente->carnet); ?></p>
                    <?php else: ?>
                        <p><strong>Cliente:</strong> No asignado</p>
                        <p><strong>Carnet:</strong> No disponible</p>
                    <?php endif; ?>
                    
                      <?php if($venta->observacion): ?>
                        <p><strong>Observaciones:</strong> <?php echo e($venta->observacion); ?></p>
                    <?php else: ?>
                        <p><strong>Observaciones:</strong> No hay observaciones</p>
                    <?php endif; ?>
                    
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('administrador')): ?>
                                <?php if($venta->estado == 1): ?>
                                <div class="d-flex flex-wrap gap-3 justify-content-start">
                                    <a href="<?php echo e(route('ventas.resumen', $venta->id)); ?>" target="_blank" class="btn btn-primary btn-lg px-4 py-2 shadow-sm">
                                        📄 Generar Venta para Cliente
                                    </a>
                                    <a href="<?php echo e(route('ventas.almacen', $venta->id)); ?>" target="_blank" class="btn btn-warning btn-lg px-4 py-2 shadow-sm">
                                        📄 Venta para Almacen
                                    </a>
                                    <a href="<?php echo e(route('ventas.simple', $venta->id)); ?>" target="_blank" class="btn btn-success btn-lg px-4 py-2 shadow-sm">
                                        📄 Generar Resumen de Venta para Cliente
                                    </a>
                                </div>
                            <?php endif; ?>
                            <?php endif; ?>
                        
                        </div>
                    </div>

                    <!-- Tabla de Productos Vendidos -->
                    <div class="table-responsive">
                        <h6 class="text-primary">📋 Productos Vendidos</h6>
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Producto</th>
                                    <th>Código</th>
                                    <th>Descripción</th>
                                    <th>Ubicación</th>
                                    <th>Marca</th>
                                    <th>Tipo de Precio</th>
                                    <th>Medida</th>
                                    <th>Cantidad</th>
                                    <th>Cantidad Total</th>
                                    <th>Precio  (Bs.)</th>
                                    <th>Total (Bs.)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $venta->productosVendidos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productoVendido): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($productoVendido->producto->nombre); ?></td>
                                        <td><?php echo e($productoVendido->producto->codigo1); ?></td>
                                        <td><?php echo e($productoVendido->producto->descripcion); ?></td>
                                        <td><?php echo e($productoVendido->producto->ubicacion->nombre ?? 'No especificada'); ?></td>
                                        <td><?php echo e($productoVendido->producto->marca); ?></td>
                                        <td><?php echo e($productoVendido->tipo_precio); ?></td>
                                        <td><?php echo e($productoVendido->tipo_medida); ?></td>
                                        <td><?php echo e($productoVendido->cantidad); ?></td>
                                        <td><?php echo e($productoVendido->cantidad_total); ?></td>
                                        <td><?php echo e(number_format($productoVendido->precio, 2)); ?></td>
                                        <td><?php echo e(number_format($productoVendido->precio_total, 2)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('administrador')): ?>
                    <!-- Botón para Aprobar o Rechazar Venta -->
                    <?php if($venta->estado == 0): ?>
                        <button class="btn btn-success btn-sm" onclick="aprobarVentaSweet('<?php echo e($venta->id); ?>', '<?php echo e($venta->codigo); ?>')">
                            ✅ Aprobar
                        </button>
                        <button class="btn btn-danger btn-sm" onclick="rechazarVentaSweet('<?php echo e($venta->id); ?>', '<?php echo e($venta->codigo); ?>')">
                            ❌ Rechazar
                        </button>
                    <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="text-center text-muted">No hay ventas registradas.</div>
    <?php endif; ?>
</div>


    <!-- Paginación -->
    <div class="d-flex justify-content-center mt-4">
        <?php echo e($ventasPaginadas->links()); ?>

    </div>
</section>

<script>
    function rechazarVentaSweet(ventaId, codigo) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: `¿Deseas rechazar la venta con código ${codigo}?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#28a745',
        confirmButtonText: 'Sí, rechazar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            // Realizar la solicitud AJAX para rechazar la venta
            $.ajax({
                url: `/public/ventas/${ventaId}/rechazar`,
                method: 'PATCH',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                contentType: 'application/json',
                success: function(response) {
                    Swal.fire(
                        '¡Rechazada!',
                        'La venta ha sido rechazada y los productos han sido devueltos al inventario.',
                        'success'
                    ).then(() => location.reload());
                },
                error: function(xhr, status, error) {
                    Swal.fire(
                        'Error',
                        'No se pudo rechazar la venta. Por favor, inténtalo nuevamente.',
                        'error'
                    );
                }
            });
        }
    });
}

</script>
<!-- Script para SweetAlert2 -->
<script>

function aprobarVentaSweet(ventaId, codigo) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: `¿Deseas aprobar la venta con código ${codigo}?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, aprobar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            // Realizar la solicitud AJAX para aprobar la venta
            $.ajax({
                url: `/public/ventas/${ventaId}/aprobar`,
                method: 'PATCH',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                contentType: 'application/json',
                success: function(response) {
                    Swal.fire(
                        '¡Aprobada!',
                        'La venta ha sido aprobada.',
                        'success'
                    ).then(() => location.reload());
                },
                error: function(xhr, status, error) {
                    if (xhr.responseJSON && xhr.responseJSON.error) {
                        Swal.fire(
                            'Error',
                            xhr.responseJSON.error,
                            'error'
                        );
                    } else {
                        Swal.fire(
                            'Error',
                            'No se pudo aprobar la venta. Por favor, inténtalo nuevamente.',
                            'error'
                        );
                    }
                }
            });
        }
    });
}

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elcomerc/public_html/resources/views/ventas/index.blade.php ENDPATH**/ ?>