

<?php $__env->startSection('content'); ?>
<section class="section">
    <!-- Encabezado -->
    <div class="section-header d-flex justify-content-between align-items-center">
        <h3 class="page__heading"> Gestión de Clientes</h3>
        <a href="<?php echo e(route('clientes.create')); ?>" class="btn btn-primary shadow">➕ Registrar Cliente</a>
    </div>
    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    
    <form method="GET" action="<?php echo e(route('clientes.index')); ?>" class="mb-4">
        <div class="input-group">
            <input type="text" name="buscar" class="form-control" placeholder="Buscar por nombre, apellidos, carnet o teléfono" value="<?php echo e(request('buscar')); ?>">
            <button type="submit" class="btn btn-primary">Buscar</button>
        </div>
    </form>
    <a href="<?php echo e(route('clientes.index')); ?>" class="btn btn-primary shadow">➕ Ver todos </a>
    
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Nombre</th>
                <th>Apellidos</th>
                <th>Carnet / NIT</th>
                <th>Teléfono</th>
                <th>Observaciones</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($cliente->nombre); ?></td>
                    <td><?php echo e($cliente->apellidos); ?></td>
                    <td><?php echo e($cliente->carnet); ?></td>
                    <td><?php echo e($cliente->telefono); ?></td>
                    <td><?php echo e($cliente->observacion); ?></td>
                    <td>
                        <span class="badge <?php echo e($cliente->estado ? 'bg-success' : 'bg-danger'); ?>">
                            <?php echo e($cliente->estado ? 'Activo' : 'Inactivo'); ?>

                        </span>
                    </td>
                    <td>
                        <a href="<?php echo e(route('clientes.edit', $cliente->id)); ?>" class="btn btn-warning btn-sm">Editar</a>
                        <form action="<?php echo e(route('clientes.destroy', $cliente->id)); ?>" method="POST" style="display:inline-block;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-sm">
                                <?php echo e($cliente->estado ? 'Desactivar' : 'Activar'); ?>

                            </button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="text-center">No se encontraron clientes.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    
    <?php echo e($clientes->links()); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elcomerc/public_html/resources/views/clientes/index.blade.php ENDPATH**/ ?>