

<?php $__env->startSection('content'); ?>
<section class="section">
    <div class="section-header" style="background-color:#ffffff">
        <h3 class="page__heading" style="color: #0e25f8;">Usuarios</h3> <!-- Título con color acorde al logo -->
    </div>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    
    <?php if(session('error')): ?>
        <div class="alert alert-danger">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    <div class="section-body">
        <div class="row">
            <div class="col-lg-12">
                <form action="<?php echo e(route('usuarios.index')); ?>" method="GET">
                    <div class="input-group mb-3">
                        <input type="text" class="form-control" placeholder="Buscar por nombre, correo o rol" name="query">
                        <div class="input-group-append">
                            <button class="btn btn-outline-secondary" style="background-color: #2264f2; color: white;" type="submit">
                                <i class="fas fa-search"></i> <!-- Icono de búsqueda -->
                            </button>
                        </div>
                    </div>
                </form>
                
                <div class="card">
                    <div class="card-body">
                        <a class="btn btn-warning" href="<?php echo e(route('usuarios.create')); ?>" style="background-color: #159e2c; color: white;">
                            <i class="fas fa-user-plus"></i> <!-- Icono de agregar usuario -->
                        </a>
                        <a class="btn btn-primary" href="<?php echo e(route('usuarios.index')); ?>" style="background-color: #2330ec;">
                            <i class="fas fa-users"></i> <!-- Icono de ver todos los usuarios -->
                        </a>
                        <div class="table-responsive">
                            <table class="table table-striped mt-2">
                                <thead style="background-color:#2f2bec">
                                    <th style="display: none;">ID</th>
                                    <th style="color:#ffffff">Nombre</th>
                                    <th style="color:#fff;">E-mail</th>
                                    <th style="color:#fff;">Rol</th>
                                    <th style="color:#fff;">Estado</th>
                                    <th style="color:#fff;">Acciones</th>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usuario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td style="display: none;"><?php echo e($usuario->id); ?></td>
                                        <td><?php echo e($usuario->name); ?></td>
                                        <td><?php echo e($usuario->email); ?></td>
                                        <td>
                                            <?php if(!empty($usuario->getRoleNames())): ?>
                                                <?php $__currentLoopData = $usuario->getRoleNames(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rolName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <h5><span class="badge badge-dark"><?php echo e($rolName); ?></span></h5>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($usuario->estado ? 'Activo' : 'Inactivo'); ?></td> <!-- Mostrar el estado -->
                                        <td>
                                            <a class="btn btn-info" href="<?php echo e(route('usuarios.edit', $usuario->id)); ?>" style="background-color: #2330ec; color: white;">
                                                <i class="fas fa-edit"></i> <!-- Icono de editar -->
                                            </a>
                                            <form action="<?php echo e(route('usuarios.change-status', $usuario)); ?>" method="POST" style="display: inline-block;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PATCH'); ?>
                                                <button type="submit" class="btn btn-sm <?php echo e($usuario->estado ? 'btn-danger' : 'btn-success'); ?>">
                                                    <i class="fas fa-toggle-<?php echo e($usuario->estado ? 'off' : 'on'); ?>"></i> <!-- Icono de activar/desactivar -->
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="pagination justify-content-end">
                            <?php echo $usuarios->links(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/offsides/public_html/resources/views/usuarios/index.blade.php ENDPATH**/ ?>