<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Ventas</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            margin: 20px;
        }

        header {
            text-align: center;
            margin-bottom: 20px;
        }

        header h1 {
            font-size: 16px;
            margin: 0;
        }

        header p {
            margin: 5px 0;
            font-size: 12px;
        }

        .venta-section {
            margin-bottom: 20px;
            border: 1px solid #ddd;
            padding: 10px;
            border-radius: 5px;
        }

        .venta-header {
            background-color: #f2f2f2;
            padding: 10px;
            margin-bottom: 10px;
        }

        .venta-header p {
            margin: 0;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 5px;
            text-align: center;
            vertical-align: middle;
            word-wrap: break-word;
            font-size: 10px;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        .totales {
            margin-top: 20px;
            font-size: 12px;
            text-align: right;
        }

        .totales span {
            font-weight: bold;
        }

        footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #555;
        }
    </style>
</head>
<body>
    <header>
        <h1>Reporte de Ventas</h1>
        <p>Generado el <?php echo e(now()->subHours(4)->format('d/m/Y H:i:s')); ?></p>

    </header>

    <?php
        $montoTotalBs = 0;
    ?>

    <?php $__currentLoopData = $ventas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="venta-header">
        <p><strong>Venta ID:</strong> <?php echo e($venta->id); ?></p>
        <p><strong>Código:</strong> <?php echo e($venta->codigo); ?></p>
        <p><strong>Usuario:</strong> <?php echo e($venta->usuario->name); ?></p>
        <p><strong>Estado:</strong> <?php echo e($venta->estado === 1 ? 'Aprobada' : 'Pendiente'); ?></p>
        <p><strong>Aprobada por:</strong> <?php echo e($venta->usuarioAprobador->name ?? 'No Aprobada'); ?></p>
        <p><strong>Fecha:</strong> <?php echo e(\Carbon\Carbon::parse($venta->fecha)->format('d/m/Y')); ?></p>
        <p><strong>Hora:</strong> <?php echo e(\Carbon\Carbon::parse($venta->hora)->subHours(4)->format('H:i:s')); ?></p>
        <p><strong>Ubicacion:</strong> 
            <?php echo e($venta->productosVendidos->pluck('producto.ubicacion.nombre')->unique()->implode(', ') ?? 'No especificada'); ?> 
        </p>
        <p><strong>Total de la Venta:</strong> <?php echo e(number_format($venta->precio_total, 2)); ?> Bs.</p>
    
        <!-- Información del cliente -->
        <p><strong>Cliente:</strong> <?php echo e($venta->cliente->nombre ?? '__________________________'); ?> <?php echo e($venta->cliente->apellidos ?? '__________________________'); ?></p>
        <p><strong>Carnet:</strong> <?php echo e($venta->cliente->carnet ?? '__________________________'); ?></p>
        <p><strong>Observaciones:</strong> <?php echo e($venta->observacion ?? '__________________________'); ?></p>
    </div>
    

            <!-- Productos de la venta -->
            <table>
                <thead>
                    <tr>
                        <th>Producto</th>
                        <th>Código</th>
                        <th>Descripción</th>
                        <th>Ubicación</th>
                        <th>Marca</th>
                        <th>Tipo de Precio</th>
                        <th>Cantidad</th>
                        <th>Cantidad Total</th>
                        <th>Precio Unitario (Bs.)</th>
                        <th>Total (Bs.)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $venta->productosVendidos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productoVendido): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $montoTotalBs += $productoVendido->precio_total;
                        ?>
                        <tr>
                            <td><?php echo e($productoVendido->producto->nombre); ?></td>
                            <td><?php echo e($productoVendido->producto->codigo1); ?></td>
                            <td><?php echo e($productoVendido->producto->descripcion); ?></td>
                            <td><?php echo e($productoVendido->producto->ubicacion->nombre ?? 'No especificada'); ?></td>
                            <td><?php echo e($productoVendido->producto->marca); ?></td>
                            <td><?php echo e($productoVendido->tipo_precio); ?></td>
                            <td><?php echo e($productoVendido->cantidad); ?></td>
                            <td><?php echo e($productoVendido->cantidad_total); ?></td>
                            <td><?php echo e(number_format($productoVendido->precio, 2)); ?> Bs.</td>
                            <td><?php echo e(number_format($productoVendido->precio_total, 2)); ?> Bs.</td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
         

            </table>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="totales">
        <p><span>Monto Total Vendido (Bs.):</span> <?php echo e(number_format($montoTotalBs, 2)); ?></p>
    </div>

    <footer>
        <p>Reporte generado automáticamente por el sistema.</p>
    </footer>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\jugueteria\resources\views/ventas/pdf.blade.php ENDPATH**/ ?>