

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="card shadow-sm border-0 rounded">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h2 class="mb-0">Gestión de Archivos Importados</h2>
            <a href="<?php echo e(route('mercancia.index')); ?>" class="btn btn-light">
                <i class="fas fa-arrow-left"></i> Volver a Mercancía
            </a>
        </div>
        <div class="card-body">
            <!-- Mensajes de éxito y error -->
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <!-- Tabla de archivos -->
            <div class="table-responsive">
                <table class="table table-striped table-bordered text-center align-middle">
                    <thead class="bg-light">
                        <tr>
                            <th>#</th>
                            <th>Nombre del Archivo</th>
                            <th>Fecha de Importación</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $archivos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $archivo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($archivo->id); ?></td>
                                <td><?php echo e($archivo->nombre); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($archivo->created_at)->format('d/m/Y H:i')); ?></td>
                                <td>
                                    <div class="btn-group" role="group" aria-label="Acciones">
                                        <!-- Descargar archivo -->
                                        <a href="<?php echo e(route('archivos.archivos.descargar', $archivo->id)); ?>" class="btn btn-info btn-sm" title="Descargar">
                                            <i class="fas fa-download"></i>
                                        </a>
                                        <!-- Eliminar archivo -->
                                        <form action="<?php echo e(route('archivos.archivos.eliminar', $archivo->id)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm" title="Eliminar Archivo">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="text-muted text-center">No hay archivos importados registrados.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Paginación -->
            <div class="d-flex justify-content-center mt-4">
                <?php echo e($archivos->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/offsides/public_html/resources/views/archivos/index.blade.php ENDPATH**/ ?>